/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SerializableCapabilityProvider<HANDLER>
implements ICapabilityProvider,
INBTSerializable<INBT> {
    protected final Capability<HANDLER> capability;
    protected final Direction facing;
    protected final HANDLER instance;
    protected final LazyOptional<HANDLER> lazyOptional;

    public SerializableCapabilityProvider(Capability<HANDLER> capability, @Nullable Direction facing, @Nullable HANDLER instance) {
        this.capability = capability;
        this.facing = facing;
        this.instance = instance;
        this.lazyOptional = this.instance != null ? LazyOptional.of(() -> this.instance) : LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return this.getCapability().orEmpty(capability, this.lazyOptional);
    }

    public final Capability<HANDLER> getCapability() {
        return this.capability;
    }

    @Nullable
    public Direction getFacing() {
        return this.facing;
    }

    @Nullable
    public final HANDLER getInstance() {
        return this.instance;
    }

    public INBT serializeNBT() {
        HANDLER instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        return this.getCapability().writeNBT(instance, this.getFacing());
    }

    public void deserializeNBT(INBT nbt) {
        HANDLER instance = this.getInstance();
        if (instance == null) {
            return;
        }
        this.getCapability().readNBT(instance, this.getFacing(), nbt);
    }
}

